DROP TABLE IF EXISTS EOS_QRTZ_JOB_LISTENERS;
DROP TABLE IF EXISTS EOS_QRTZ_TRIGGER_LISTENERS;
DROP TABLE IF EXISTS EOS_QRTZ_FIRED_TRIGGERS;
DROP TABLE IF EXISTS EOS_QRTZ_PAUSED_TRIGGER_GRPS;
DROP TABLE IF EXISTS EOS_QRTZ_SCHEDULER_STATE;
DROP TABLE IF EXISTS EOS_QRTZ_LOCKS;
DROP TABLE IF EXISTS EOS_QRTZ_SIMPLE_TRIGGERS;
DROP TABLE IF EXISTS EOS_QRTZ_CRON_TRIGGERS;
DROP TABLE IF EXISTS EOS_QRTZ_BLOB_TRIGGERS;
DROP TABLE IF EXISTS EOS_QRTZ_TRIGGERS;
DROP TABLE IF EXISTS EOS_QRTZ_JOB_DETAILS;
DROP TABLE IF EXISTS EOS_QRTZ_CALENDARS;
DROP TABLE IF EXISTS EOS_QRTZ_SCHEDULER;

CREATE TABLE EOS_QRTZ_JOB_DETAILS (
    JOB_NAME VARCHAR(80) NOT NULL,
    JOB_GROUP VARCHAR(80) NOT NULL,
    DESCRIPTION VARCHAR(120),
    JOB_CLASS_NAME VARCHAR(128) NOT NULL,
    IS_DURABLE INTEGER NOT NULL,
    IS_VOLATILE INTEGER NOT NULL,
    IS_STATEFUL INTEGER NOT NULL,
    REQUESTS_RECOVERY INTEGER NOT NULL,
    JOB_DATA BLOB,
    PRIMARY KEY (JOB_NAME, JOB_GROUP)
);

CREATE TABLE EOS_QRTZ_JOB_LISTENERS (
    JOB_LISTENER VARCHAR(80) NOT NULL,
    JOB_NAME VARCHAR(80) NOT NULL,
    JOB_GROUP VARCHAR(80) NOT NULL,
    PRIMARY KEY (JOB_LISTENER, JOB_NAME, JOB_GROUP),
    FOREIGN KEY (JOB_NAME,JOB_GROUP)
       REFERENCES EOS_QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)
);

CREATE TABLE EOS_QRTZ_TRIGGERS (
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    IS_VOLATILE INTEGER NOT NULL,
    DESCRIPTION VARCHAR(120),
    NEXT_FIRE_TIME BIGINT,
    PREV_FIRE_TIME BIGINT,
    TRIGGER_STATE VARCHAR(16) NOT NULL,
    TRIGGER_TYPE VARCHAR(8) NOT NULL,
    START_TIME BIGINT NOT NULL,
    END_TIME BIGINT,
    CALENDAR_NAME VARCHAR(80),
    MISFIRE_INSTR SMALLINT DEFAULT 2,
    JOB_DATA BLOB,
    JOB_NAME VARCHAR(80) NOT NULL,
    JOB_GROUP VARCHAR(80) NOT NULL,
    PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP),
    FOREIGN KEY (JOB_NAME,JOB_GROUP)
       REFERENCES EOS_QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)
);

CREATE TABLE EOS_QRTZ_CALENDARS (
    CALENDAR_NAME VARCHAR(80) NOT NULL,
    CALENDAR BLOB NOT NULL,
    PRIMARY KEY (CALENDAR_NAME)
);

CREATE TABLE EOS_QRTZ_BLOB_TRIGGERS (
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    BLOB_DATA BLOB,
    PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP)
       REFERENCES EOS_QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE EOS_QRTZ_CRON_TRIGGERS (
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    CRON_EXPRESSION VARCHAR(80) NOT NULL,
    TIME_ZONE_ID VARCHAR(80),
    PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP)
       REFERENCES EOS_QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE EOS_QRTZ_FIRED_TRIGGERS (
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    IS_VOLATILE INTEGER NOT NULL,
    INSTANCE_NAME VARCHAR(80) NOT NULL,
    FIRED_TIME BIGINT NOT NULL,
    STATE VARCHAR(16) NOT NULL,
    JOB_NAME VARCHAR(80),
    JOB_GROUP VARCHAR(80),
    IS_STATEFUL INTEGER,
    REQUESTS_RECOVERY INTEGER,
    PRIMARY KEY (ENTRY_ID)
);

CREATE TABLE EOS_QRTZ_PAUSED_TRIGGER_GRPS (
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    PRIMARY KEY (TRIGGER_GROUP)
);

CREATE TABLE EOS_QRTZ_SCHEDULER_STATE (
    INSTANCE_NAME VARCHAR(80) NOT NULL,
    LAST_CHECKIN_TIME BIGINT NOT NULL,
    CHECKIN_INTERVAL BIGINT NOT NULL,
    RECOVERER VARCHAR(80),
    PRIMARY KEY (INSTANCE_NAME)
);

CREATE TABLE EOS_QRTZ_SIMPLE_TRIGGERS (
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    REPEAT_COUNT BIGINT NOT NULL,
    REPEAT_INTERVAL BIGINT NOT NULL,
    TIMES_TRIGGERED BIGINT NOT NULL,
    PRIMARY KEY (TRIGGER_NAME, TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP)
       REFERENCES EOS_QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE EOS_QRTZ_TRIGGER_LISTENERS (
    TRIGGER_LISTENER VARCHAR(80) NOT NULL,
    TRIGGER_NAME VARCHAR(80) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    PRIMARY KEY (TRIGGER_LISTENER, TRIGGER_NAME, TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP)
       REFERENCES EOS_QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE EOS_QRTZ_LOCKS (
    LOCK_NAME VARCHAR(40) NOT NULL,
    PRIMARY KEY (LOCK_NAME)
);

CREATE TABLE EOS_QRTZ_SCHEDULER(
       UUID  VARCHAR(64)  NOT NULL,
       SCHEDULER VARCHAR(64),
       NODE  VARCHAR(64),
       STATUS  DECIMAL(2,0),
       HEARTBEATTIME   DECIMAL(20,0),
       VALIDATEFLAG  DECIMAL(2,0),
       VALIDATETIME  DATETIME,
       INVALIDATETIME  DATETIME,
       PRIMARY KEY (UUID)
);

INSERT INTO EOS_QRTZ_LOCKS VALUES('TRIGGER_ACCESS');
INSERT INTO EOS_QRTZ_LOCKS VALUES('JOB_ACCESS');
INSERT INTO EOS_QRTZ_LOCKS VALUES('CALENDAR_ACCESS');
INSERT INTO EOS_QRTZ_LOCKS VALUES('STATE_ACCESS');
INSERT INTO EOS_QRTZ_LOCKS VALUES('MISFIRE_ACCESS');
INSERT INTO EOS_QRTZ_SCHEDULER(UUID,SCHEDULER,STATUS,HEARTBEATTIME,VALIDATEFLAG) VALUES ('SCHEDULE_CTRL','SCHEDULE_CTRL',0,0,1);