const devMode = process.env.NODE_ENV === 'development';
const appName = 'formApp'
const resolve = (dir) => `./src/views/${dir}`
module.exports = {
  name: appName,
  filename: `remoteEntry.js`,
  exposes: { // 暴露页面
    './FormTemplate': './src/views/form/index.vue',
    './store': './src/store/index.js', // 默认将子应用 store 导出,供base应用注册
  },
  remotes: {
    base: devMode ? 'base@http://localhost:8000/remoteEntry.js': 'base@/remoteEntry.js'
  },
}