export default {
  data() {
    return {
      loading: false
    }
  },
  created() {
    const _this = this
    window.loadFormData = (processContext, pcfContext) => {
      return new Promise((resolve) => {
        this.form = pcfContext.formData
        resolve(true)
      })
    }
    window.beforeSaveFormData = (processContext, bfpContext) => {
      return new Promise((resolve) => {
        // 可以返回一个promise， 也可以直接返回boolean值
        _this.$refs['form'].validate((valid) => {
          if (valid) {
            resolve(true)
          } else {
            resolve(false)
          }
        });
      })
    }
    window.saveFormData = (processContext, bfpContext) => {
      // 如果有异步操作，返回一个promise，否则直接返回form数据
      return new Promise((resolve) => {
        resolve(this.form)
      })
    }
    window.afterSaveFormData = (processContext, bfpContext) => {
      // 如果有异步操作，返回一个promise，否则直接返回form数据
      return new Promise((resolve) => {
        resolve()
      })
    }
  },
  destroyed() {
    window.loadFormData = undefined
    window.beforeSaveFormData = undefined
    window.saveFormData = undefined
    window.afterSaveFormData = undefined
  },
}
