package com.example.demoformdata.controller;

import com.example.demoformdata.service.FormDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @author : xifanzhou [mailto: duanww@primeton.com]
 * @Description :
 */
@RestController
@RequestMapping("/api/form-data")
public class FormDataController {

    @Autowired
    private FormDataService formDataService;

    @PostMapping("/save")
    public String[] saveFormData(@RequestBody Map<String, Object> params){
        List<Map<String, Object>> formData = (List<Map<String, Object>>)params.get("formData");
        Object processContext = params.get("processContext");
        return formDataService.saveFormData(formData,processContext);
    }

    @PostMapping("/query")
    public Map<String,Object> queryFormData(@RequestBody Map<String, Object> params){
        String  bizPrimaryKeyId = (String)params.get("bizPrimaryKeyId");
        List<String> bizPrimaryKeyValue = (List) params.get("bizPrimaryKeyValue");
        Object processContext = params.get("processContext");
        return formDataService.queryFormData(bizPrimaryKeyId,bizPrimaryKeyValue,processContext);
    }
}
