package com.example.demoformdata.service;


import com.example.demoformdata.Student;
import com.example.demoformdata.mapper.StudentMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @author : xifanzhou [mailto: duanww@primeton.com]
 * @Description :
 */
@Service
public class FormDataService {

    @Autowired(required = false)
    private StudentMapper studentMapper;

    @Transactional(rollbackFor = Exception.class)
    public String[] saveFormData(List<Map<String, Object>> formData,Object processContext){
        String[] primaryKeyValues = new String[1];
        Map<String, Object> stringObjectMap = formData.get(0);
        String id = (String)stringObjectMap.get("id");
        String actName = (String)stringObjectMap.get("actName");
        String region = (String)stringObjectMap.get("region");
        String resource = (String)stringObjectMap.get("resource");
        String actDesc = (String)stringObjectMap.get("actDesc");
        //主键为空新增
        if(StringUtils.isEmpty(id)){
            id = UUID.randomUUID().toString();
            Student student = new Student(id,actName,region,resource,actDesc);
            studentMapper.insert(student);
            primaryKeyValues[0] = id;
        }else {
            Student student = new Student(id,actName,region,resource,actDesc);
            studentMapper.updateById(student);
            primaryKeyValues[0] = id;
        }
        return primaryKeyValues;
    }

    public Map<String,Object> queryFormData(String bizPrimaryKeyId,List<String> bizPrimaryKeyValue,Object processContext){
        String s = bizPrimaryKeyValue.get(0);
        Student student = studentMapper.selectById(s);
        Map<String,Object> result = new HashMap<>();
        result.put("id",student.getId());
        result.put("actName",student.getActName());
        result.put("region",student.getRegion());
        result.put("resource",student.getResource());
        result.put("actDesc",student.getActDesc());
        return result;
    }
}
